/**
* \file: message_recvr.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: automounter
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2010, 2011 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#ifndef AMS_IPC_MESSAGE_RECVR_H
#define AMS_IPC_MESSAGE_RECVR_H

#include "utils/automounter_types_internal.h"
#include "ipc/message_buffer.h"

message_buffer_t *message_recvr_create_receiver_buffer(void);

void message_recvr_destroy_receiver_buffer(message_buffer_t *msg_buf);

error_code_t message_recvr_receive_msg(message_buffer_t *recvr_buffer, int a_socket);

message_type_t message_recvr_get_msg_type(message_buffer_t *recvr_buffer);

void message_recvr_get_msg_data(message_buffer_t *recvr_buffer, void **buf_ptr, size_t *buffer_size_ptr);

const char *message_recvr_get_first_msg_string(message_buffer_t *recvr_buffer);

const char *message_recvr_get_next_msg_string(message_buffer_t *recvr_buffer);

#endif
